<?php
session_start();
include('includes/db.php');

$config = $pdo->query("SELECT * FROM configuracoes LIMIT 1")->fetch(PDO::FETCH_ASSOC);
$logo = !empty($config['logo']) ? 'uploads/' . $config['logo'] : 'https://via.placeholder.com/100x100?text=Logo';

if (isset($_SESSION['usuario_id'])) {
    header("Location: dashboard.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = $_POST['usuario'];
    $senha = $_POST['senha'];

    $stmt = $pdo->prepare("SELECT * FROM configuracoes WHERE usuario = ?");
    $stmt->execute([$usuario]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && $senha === $user['senha']) {
        $_SESSION['usuario_id'] = $user['id'];
        header("Location: dashboard.php");
        exit;
    } else {
        $erro = "Usuário ou senha incorretos!";
    }
}

$titulo = $config['titulo'] ?? 'SPXTV';
$logo = !empty($config['logo']) ? 'uploads/' . $config['logo'] : '';
?>
<!DOCTYPE html>
<html lang="pt-br" class="">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
  <title>Login - <?= $titulo ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class'
    };
  </script>
  <style>
    body {
      background: linear-gradient(to right, #0f172a, #1e293b);
    }
    .glass {
      background: rgba(255, 255, 255, 0.05);
      backdrop-filter: blur(12px);
      border: 1px solid rgba(255, 255, 255, 0.1);
    }
    .fade-in {
      animation: fadeIn 1s ease-in-out;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>
<body class="flex items-center justify-center min-h-screen text-white font-sans transition-all duration-300">

  <div class="glass rounded-2xl p-8 w-full max-w-sm text-center shadow-2xl fade-in">
    <?php if ($logo): ?>
      <img src="<?= $logo ?>" alt="Logo" class="w-20 h-20 mx-auto mb-4 rounded-full shadow-lg border border-gray-500">
    <?php endif; ?>

    <h2 class="text-2xl font-bold mb-2 animate-bounce">Bem-vindo ao</h2>
    <h1 class="text-3xl font-extrabold text-blue-400 mb-6"><?= $titulo ?></h1>

    <?php if (isset($erro)): ?>
      <div class="bg-red-600 text-white p-2 rounded mb-4"><?= $erro ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-4 text-left" onsubmit="return validarCampos()">
      <div>
        <label class="text-sm">Usuário</label>
        <div class="flex items-center bg-gray-900 rounded px-3 py-2">
          <svg class="w-5 h-5 text-gray-400 mr-2" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path d="M16 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
            <circle cx="12" cy="7" r="4"></circle>
          </svg>
          <input type="text" name="usuario" id="usuario" required class="bg-transparent outline-none w-full" />
        </div>
      </div>

      <div>
        <label class="text-sm">Senha</label>
        <div class="flex items-center bg-gray-900 rounded px-3 py-2">
          <svg class="w-5 h-5 text-gray-400 mr-2" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
          </svg>
          <input type="password" name="senha" id="senha" required class="bg-transparent outline-none w-full" />
          <button type="button" onclick="toggleSenha()" class="ml-2 text-gray-400 hover:text-white">
            👁️
          </button>
        </div>
      </div>

      <div class="flex items-center justify-between text-sm text-gray-400">
        <label><input type="checkbox" class="mr-1"> Lembrar acesso</label>
      </div>

      <button type="submit" class="w-full py-2 px-4 bg-blue-600 hover:bg-blue-700 rounded transition duration-200 font-semibold shadow">
        Entrar
      </button>
    </form>

    <p class="text-xs text-gray-400 mt-6">© <?= date('Y') ?> LCS FORNECEDOR - Todos os direitos reservados.</p>
  </div>

  <script>
    function toggleSenha() {
      const senha = document.getElementById('senha');
      senha.type = senha.type === 'password' ? 'text' : 'password';
    }

    function validarCampos() {
      const usuario = document.getElementById('usuario');
      const senha = document.getElementById('senha');
      if (!usuario.value.trim() || !senha.value.trim()) {
        alert('Por favor, preencha todos os campos.');
        return false;
      }
      return true;
    }
;
  </script>
</body>
</html>
